--
--  CTMAppDelegate.applescript
--  Electricity Cost Calculator
--
--  Created by Shane Stanley on 2/08/12.
--  Copyright (c) 2012 c't. All rights reserved.
--

script CTMAppDelegate
	property parent : class "NSObject"
	
	-- bindings properties
	property listOfDevices : {"Aquarium", "Backofen", "Boiler", "Computer", "Drucker", "Durchlauferhitzer", "Router", "Fernseher", "Fön", "Herd", "Kühlschrank", "Toaster"} -- fügen Sie hier eigene Begriffe hinzu
	
	-- outlet properties
	property deviceField : missing value
	property consumptionField : missing value
	property dailyUseField : missing value
	property rateField : missing value
	property outputView : missing value
	property dailyTypeButtons : missing value
	
	-- andere properties
	property formatter : missing value -- dieses property enthält den Nummern-Formatierer
	
	on addEntry_(sender)
		set theDevice to deviceField's stringValue()

		if theDevice = missing value then
			tell current application to beep
			return
		end if
		
        set theDevice to theDevice as text
		
        if theDevice = "" then
			tell current application to beep
			return
		end if
		
        set theConsumption to consumptionField's floatValue() as real
		set dailyUse to dailyUseField's floatValue() as real
		set theRate to rateField's floatValue() as real
		set dailyWatts to theConsumption * dailyUse / 1000
		set dailyCost to dailyWatts * theRate
		
        -- set theInfo to current application's NSString's stringWithFormat_("Your %@ consumes approximately:" & ¬
		-- 	linefeed & linefeed & ¬
		-- 	" %@ kWh a day = %@ EUR" & linefeed & ¬
		-- 	" %@ kWh a week = %@ EUR" & linefeed & ¬
		-- 	" %@ kWh a month = %@ EUR" & linefeed & ¬
		-- 	" %@ kWh a year = %@ EUR" & linefeed, ¬
		-- 	theDevice, dailyWatts, dailyCost, dailyWatts * 7, dailyCost * 7, dailyWatts * 30, dailyCost * 30, dailyWatts * 365, dailyCost * 365)
		
        set theInfo to current application's NSString's stringWithFormat_("Ihr %@ verbraucht durchschnittlich:" & ¬
			linefeed & linefeed & ¬
			" %@ kWh pro Tag = %@ EUR" & linefeed & ¬
			" %@ kWh pro Woche = %@ EUR" & linefeed & ¬
			" %@ kWh pro Monat = %@ EUR" & linefeed & ¬
			" %@ kWh pro Jahr = %@ EUR" & linefeed & linefeed, ¬
			theDevice, calculateValue(dailyWatts, 1), calculateValue(dailyCost, 1), ¬
			calculateValue(dailyWatts, 7), calculateValue(dailyCost, 7), ¬
			calculateValue(dailyWatts, 30), calculateValue(dailyCost, 30), ¬
			calculateValue(dailyWatts, 365), calculateValue(dailyCost, 365))
		
        set theStyledInfo to current application's NSMutableAttributedString's alloc()'s initWithString_(theInfo)
		
        tell outputView's textStorage() to appendAttributedString_(theStyledInfo)
		set theLength to outputView's textStorage()'s |length|()
		tell outputView to scrollRangeToVisible_({location:theLength, |length|:0})
	end addEntry_
	
	on calculateValue(theAmount, numberOfDays)
		if numberOfDays = 1 then -- keine Berechnungs nötig
			set theValue to theAmount
		else
			set dailyType to dailyTypeButtons's selectedRow() as integer
			if dailyType = 0 then -- täglich
				set theValue to theAmount * numberOfDays
			else if dailyType = 1 then -- nur wochentags, bzw. 5 von 7
				set theValue to theAmount * numberOfDays * 5 / 7
			else -- nur am Wochenende, 2 von 7
				set theValue to theAmount * numberOfDays * 2 / 7
			end if
		end if
		
        -- Nachkommastellen formatieren
		return formatter's stringFromNumber_(theValue)
	end calculateValue
	
	
	on saveTheText_(sender)
		set theText to (outputView's textStorage()'s |string|()) as text
		
        if length of theText = 0 then
			tell current application to beep
			return
		end if
		
        set newFile to (choose file name with prompt "Speicher die Daten in:" default name "Results.txt" default location path to desktop)
		set fileRef to (open for access newFile with write permission)
		set eof fileRef to 0
		write theText to fileRef
		close access fileRef
    end saveTheText_
	
	on clearReport_(sender)
		set theLength to outputView's textStorage()'s |length|()
		tell outputView's textStorage() to deleteCharactersInRange_({location:0, |length|:theLength})
	end clearReport_
	
	
	on applicationWillFinishLaunching_(aNotification)
        -- Fügen Sie hier Code ein, um Dinge für Ihre Applikation einzurichten, bevor irgendwelche Dateien geöffnet sind
		set my formatter to current application's NSNumberFormatter's alloc()'s init()
		formatter's setMaximumFractionDigits_(2)
		formatter's setMinimumFractionDigits_(2)
		formatter's setMinimumIntegerDigits_(1)
	end applicationWillFinishLaunching_
	
	on applicationShouldTerminate_(sender)
        -- Fügen Sie hier Code ein, um Dinge zu erledigen, bevor die Applikation beendet ist
		return current application's NSTerminateNow
	end applicationShouldTerminate_
	
end script